clearvars; close all; clc;

% This script produce a movie for the KSE spatiotemporal 
% Pattern for the same initial condition and under 
% different number of modes

[Us,xs] = getKSE_utx(8);     %small number of modes (K < 12)
[Um,xm] = getKSE_utx(16);    %medium number of modes (15<K<21)
[Ul,xl,t] = getKSE_utx(50);  %large number of modes (K > 21)

v = VideoWriter('KSEdynamic');
open(v)

fig = figure;
for i = 1:length(t)
    plot(xs,Us(i,:),'-r','LineWidth',2)
    hold on
    plot(xm,Um(i,:),'-b','LineWidth',2)
    plot(xl,Ul(i,:),'-g','LineWidth',2)
    hold off
    ylim([0 6])
    xlim([0 2*pi])
    xlabel('$x$',"Interpreter","latex")
    ylabel('$|u(t,x)|$',"Interpreter","latex")
    set(gca,'FontSize',20)
    drawnow
    writeVideo(v,getframe(fig));
    
end

close(v)