function Xdot = KSEode(t,x)
% Kuramoto-Sivashinsky Equations

% Initialize Xdot
Xdot = zeros(size(x));

% Set parameters
nu=0.029910; d = length(x) ;
L = 2*pi;    q = 2*pi/L;

for k = 1:d
   sm = 0;

   for m = 1:k
     if (k-m ~= 0) 
         sm = sm + x(m) * sign(k-m) * x(abs(k-m));
     end
   end

   for m = (k+1):d
     sm = sm - x(m) * sign(m-k) * x(abs(m-k)); 
   end

   for m = 1:(d-k)
	 sm = sm - x(m) * x(k+m);
   end

   kq = k * q;
   Xdot(k) = x(k)*(1-nu*(kq^2))*(kq^2) - kq*sm; 

end

    

end