function [u,x,t] = getKSE_utx(K)
% return the time domain solution of KSE for 
% chosen number of modes K
rng(1)
a0 = 0.05*rand(K,1);  %Initial condition (small value)

t0 = 0; tfinal = 10; %Initial and final time
h = 0.001; %time step

% Set the ode solver options 
options = odeset('RelTol',1e-10,'AbsTol',1e-10);

% Use ode solver to solve the ode defined 
% in the function KSEode.m
[t, a] = ode45(@KSEode,(t0:h:tfinal),a0,options);

u = zeros(length(t),K); %Initialize time domain solution
x = linspace(0,2*pi,K); % partition spatial domain for K measuring points
for n = 1:length(t) %loop over all trajectories
    for k = 1:length(x) % loop through each spatial point
        u(n,k) = 1.i .* sum(a(n,:).*exp(1.i .* k .* x));
    end
end

u = abs(u);
end

