close all; clear;
LorenzF2; %generate data over in routine Lorenz
X=X'; %y=x(:,2:end); x=x(:,1:end-1); tn=size(x,2); 
len=floor(size(X,2)/2); lensv=size(X,2)-len;
x=X(:,1:len-1); y=X(:,2:len); xt=X(:, len+1:end-1); yt=X(:, len+2:end);  L=len; %cut in half

N=size(x,1); N=size(x,1);  yp=zeros(size(x)); T=T(1:len);
M=500;

A=randn(M,M); %make normal random graph
l=max(abs(eigs(A))); 
q=1.2;  A=A/(l*q);  %Scale specral radius to 1/q.
eigs(A) 

q=40; Win=(rand(M,N)-1/2)/q; %readin matrix - scale maxium scale to 1/q.

r=Win*x(:,1); r0=r; r=zeros(size(r));
R=Win*x; R0=R(:,1:end-1); R1=R(:,2:end); %A=R1*pinv(R0); %A=(lasso(R0',R1')');

[rkeep]=neuro(r,r,A);
a=0.0; %how leaky
for i=1:size(x,2)
    [r]=a*r+(1-a)*neuro(Win*x(:,i),r,A);
    rp(:,i)=r;
end

R=rp;
R=[rp; rp.^2];  %In case we would rather make the R data also have squares
mR=size(R,1); 
alpha=1.e-5;
b3=y*R'*pinv(R*R'+alpha*eye(mR,mR)); 
yp=b3*R;

x0=xt(:,1); %x0=x0+.1*randn(size(x0)); %make initial condition a little perturbed from true IC which generated data
xs=x0; L=floor((floor(20/dt)-1)/2);
yk=[]; rpp=[];
for i=1:L
    [r]=a*r+(1-a)*neuro(Win*xs,r,A);
    R=r; 
    R=[r; r.^2];  %In case we would rather make the R data also have squares
    xs=b3*R;
    yk(:,i)=xs; %read out
end

%Make some pictures
figure; plot3(yk(1,:),yk(2,:),yk(3,:),'r'); hold on; plot3(x0(1),x0(2),x0(3),'or'); xlabel('x(t)'); ylabel('y(t)'); zlabel('z(t)')
l=length(yk);


figure
subplot(4,1,1); plot(T(1:L),yk(1,:),'r'); hold on; plot(T(1:L),yt(1,1:L),'b'); xlabel('t'); ylabel('x(t)'); title('full sim, blue is true'); 
subplot(4,1,2); plot(T(1:L),yk(2,:),'r'); hold on; plot(T(1:L),yt(2,1:L),'b'); xlabel('t'); ylabel('y(t)'); 
subplot(4,1,3); plot(T(1:L),yk(3,:),'r'); hold on; plot(T(1:L),yt(3,1:L),'b'); xlabel('t'); ylabel('z(t)');  
subplot(4,1,4); plot(T(1:L),abs(yk(1,:)'-yt(1,1:L)')); xlabel('t'); ylabel('error(t)')
