clear all
close all


N=5000; x=2*rand(1,N); y=rand(1,N);

y=rand(1,N)*5*1000000-2.5*1000000; miy=-2.5*1000000; may=5*1000000-2.5*1000000; miy=1.5*miy; may=1.5*may;
x=rand(1,N)*1000000*6.371*pi; mix=0; mx=1000000*6.371*pi; mx=2*mx;
x=double(x); y=double(y);
period=86400*10;
%mix=min(x); max=max(x); miy=min(y); may=max(y);

%
x=double(x); y=double(y);
z0g=[x' y'];
options = odeset('RelTol',1e-6,'AbsTol',1e-6);
 
[T,Y] = ode45(@VectorizedRossbyWavecode,[0:.2*period: 5*period],z0g,options);

Xfinal = Y(end,1:N);
Yfinal = Y(end,N+1:2*N);
Xall=Y(:,1:N); Yall=Y(:,N+1:2*N); 

z2=[Xfinal,Yfinal];
z2=reshape(z2,[],2);

figure; plot(z2(:,1),z2(:,2),'*')

figure; hold on;
for i=1:size(Xall,2)
    plot(Xall(:,i),Yall(:,i))
end
plot(Xall(1,:),Yall(1,:),'*r'); plot(Xall(end,:),Yall(end,:),'*k');
X=[Xall;Yall]';

% %Mahalanobis distances
% %%%%
% options = statset('Display','final');
% %gm = fitgmdist(X,2,'Options',options);
% gm = fitgmdist(X,length(X),'Options',options);

%%%
%idx=kmeans(X,2,'Distance','cityblock')
idx=kmeans(X,2,'Distance','cityblock')
%idx=kmemedois(X,2,'Distance','sqeuclidean')
figure; hold on;  plot(x(find(idx==2)),y(find(idx==2)),'.r' ); plot(x(find(idx==1)),y(find(idx==1)),'.b' )

figure; 
for i=1:length(T);
     plot(Xall(i,find(idx==2)),Yall(i,find(idx==2)),'.r' ); hold on; plot(Xall(i,find(idx==1)),Yall(i,find(idx==1)),'.b' )
     axis([mix mx miy may]); drawnow;
     F(i)=getframe; hold off;
end
    
i=1; figure;
axis([mix mx miy may]); plot(Xall(i,find(idx==2)),Yall(i,find(idx==2)),'.r' ); hold on; plot(Xall(i,find(idx==1)),Yall(i,find(idx==1)),'.b' )
i=length(T); figure;
axis([mix mx miy may]); plot(Xall(i,find(idx==2)),Yall(i,find(idx==2)),'.r' ); hold on; plot(Xall(i,find(idx==1)),Yall(i,find(idx==1)),'.b' )
i=length(T); figure;
axis([mix mx miy may]); plot(Xall(i,find(idx==2)),1-Yall(i,find(idx==2)),'.r' ); hold on; plot(Xall(i,find(idx==1)),1-Yall(i,find(idx==1)),'.b' )

movie(F,1,2)
