function dy = VectorizedRossbyWavecode(t,z)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is a vectorized Rossby Wave equation code.
%It is mainly used in ode45 to get the final positions of given points.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Define the parameters. 
%      U0=63.66;
%      %U0=44.31;
%      c2=.205*U0;
%      c3=.7*U0;
%      A3=.2;
%      A2=.4;
         
     U0=44.31;
     c2=.205*U0;
     c3=.461*U0;
     A3=.3;
     %A2=.9;
     A2=.1;
%    
     A1=.075;
     L=1770000;
     re=6371000;
     k1=2/re; k2=4/re; k3=6/re;
     o2=(c2-c3)*k2;
     o1=o2*((sqrt(5)-1)/2);
     
     
 %% The details of the equations of Rossby Wave.    
     
     n=length(z)/2;
     
     dy = zeros(2*n,1);
     x=z(1:n);
     y=z(n+1:2*n);
      
   dy(1:n)=-(c3-U0.*sech(y./L).^2+...
           A3*U0*2.*sech(y./L).^2.*(-tanh(y./L)).*cos(k3.*x)+...
           A2*U0*2.*sech(y./L).^2.*(-tanh(y./L)).*cos(k2.*x-o2*(t))+...
           A1*U0*2.*sech(y./L).^2.*(-tanh(y./L)).*cos(k1.*x-o1*(t)));
   
   dy(n+1:2*n)=-k3*A3*U0*L.*sech(y./L).^2.*sin(k3.*x)-...
               k2*A2*U0*L.*sech(y/L).^2.*sin(k2*x-o2*(t))-...
               k1*A1*U0*L.*sech(y./L).^2.*sin(k1*x-o1*(t));
   
end





