rng(1); % For reproducibility
size_data1 = 100;
r = sqrt(rand(size_data1,1));
t = 2*pi*rand(size_data1,1);
data1 = [r.*cos(t), r.*sin(t)];
% Radius
% Angle
% Points
size_data2 = 100;
r2 = sqrt(3*rand(size_data2,1)+1);  % Radius
t2 = 2*pi*rand(size_data2,1);       % Angle
data2 = [r2.*cos(t2), r2.*sin(t2)]; % Points
               
figure;
plot(data1(:,1),data1(:,2),'r.','MarkerSize',15)
hold on
plot(data2(:,1),data2(:,2),'b.','MarkerSize',15)
ezpolar(@(x)1);ezpolar(@(x)2);
axis equal
hold off


X = [data1;data2]; % Matrix, where each row is one feature
size_data = size_data1 + size_data2;
Y = ones(size_data,1); % Vector of classes for each feature
Y(1:size_data1) = -1;


SVMModel = fitcsvm(X,Y,'KernelFunction','rbf',...
               'Standardize',true,...
               'ClassNames',[-1,1]);
           
XTest =[1 2; .1 .8] ; % Matrix, where each row is one feature
YTest = [1 -1]; % Vector of ground-truth classes for each feature

[YTestHat,score] = predict(SVMModel,XTest)

