close all; clear;

%%%%%%Lets do spectral partitioning of a crazy data set

%%%Date from Mathworks
%%%%%%%%%
rng('default') % For reproducibility

% Parameters for data generation
N = 300;  % Size of each cluster
r1 = 2;   % Radius of first circle
r2 = 4;   % Radius of second circle
theta = linspace(0,2*pi,N)';

X1 = r1*[cos(theta),sin(theta)]+ rand(N,1); 
X2 = r2*[cos(theta),sin(theta)]+ rand(N,1);
X = [X1;X2]; % Noisy 2-D circular data set

%%%Built in spectral partitioning.
idx = spectralcluster(X,2);
gscatter(X(:,1),X(:,2),idx);


%%%Home made spectral partitioning.
D = pdist2(X,X,'euclidean');
size(D)
sigma=.2;
W=sparse(exp(-D.*D./(2*sigma^2))); W2=exp(-D.*D./(2*sigma^2));
L=(diag(sum(W))-W); L2=(diag(sum(W2))-W2); 

k=10; %Find k smallest eigs
[V,d]=eigs(L2,k,'smallestabs')
diag(d)
figure; plot(V(:,2))
figure; plot(sort(V(:,2)))
idx2=find(V(:,2)<0);  idx2c=find(V(:,2)>0); 

figure; hold on
plot(X(idx2,1),X(idx2,2),'.')
plot(X(idx2c,1),X(idx2c,2),'.r')

