clearvars; close all; clc;

N = 512;

nu = 5e-4;

L = 2*pi;

[x,y] = meshgrid(linspace(0,L,N));

Tf = 150;

dt = 0.01;
t = 0;

ptr = VideoWriter('Navier_Stokes_April_2021.avi');
ptr.FrameRate = 20;
open(ptr)

k = 0;
j = 1;

H = InitCond;


eta = 0;%0.00*rand(N); %no noise

W = H + eta;


What = fft2(W);


kx = 1i*ones(1,N)'*(mod((1:N)-ceil(N/2 + 1),N) - floor(N/2));
ky = 1i*(mod((1:N)'-ceil(N/2 + 1),N) - floor(N/2))*ones(1,N);

Titi = (kx<2/3*N)&(ky<2/3*N);

Lhat = kx.^2 + ky.^2;

ksqr = Lhat; ksqr(1,1) = 1;

fig = figure('Units','centimeters','Position',[25 25 30 30]);
while t<Tf
    disp(t)
    psi_hat = -What./ksqr;
    
    u = real(ifft2( ky.*psi_hat));
    v = real(ifft2(-kx.*psi_hat));
    
    Wx = real(ifft2(kx.*What));
    Wy = real(ifft2(ky.*What));
    
    VgradW = u.*Wx + v.*Wy;
    VgradWhat = fft2(VgradW);
    VgradWhat = Titi.*VgradWhat;
    
    
    What_new = 1./(1/dt - 0.5*nu*Lhat).*((1/dt + 0.5*nu*Lhat).*What-VgradWhat);
    
    if (k==20)
        W = real(ifft2(What_new));
        
%         subplot(1,2,1)
        surf(x,y,W);
        view(0,90)
        colorbar;
        shading interp;
        colormap(jet)
        axis([0 2*pi 0 2*pi])
        
        xticks([0 0.5*pi pi 1.5*pi 2*pi])
xticklabels({'0','{\pi}/{2}','\pi','{3\pi}/{2}','2\pi'})

yticks([0 0.5*pi pi 1.5*pi 2*pi])
yticklabels({'0','{\pi}/{2}','\pi','{3\pi}/{2}','2\pi'})

title(['time $t = $ ' num2str(round(t,1))],'interpreter','latex')

set(gca,'FontSize',15,'Color',0.9*[1 1 1])

xlabel('$x$','interpreter','latex','FontSize',22,'FontWeight','bold')
ylabel('$y$','interpreter','latex','Rotation',0,'FontSize',22,'FontWeight','bold')


axis([0 2*pi 0 2*pi])
        
        
        drawnow
        writeVideo(ptr,getframe(fig))
        k = 0;
    end
    
    What = What_new;
    t = t + dt;
    k = k+1;
end
close(ptr)